//
//  $Id: WXKPhone.h 108 2009-06-24 14:54:10Z fujidana $
//  Copyright 2006 FUJIDANA. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <termios.h>

typedef enum _WXKPhoneDataType {
	WXKPhoneContactDataType = 3,
	WXKPhoneLightMailDataType = 4,
	WXKPhoneEmailDataType = 5,
	WXKPhoneFileDataType = 6,
	WXKPhoneScheduleDataType = 7,
	WXKPhoneBookmarkDataType = 8
} WXKPhoneDataType;

typedef enum _WXKWhoneStatus {
	WXKPhoneStatusNotOpen = 0,
	WXKPhoneStatusConfigured,
	WXKPhoneStatusConnected,
	WXKPhoneStatusLoggedIn
} WXKWhoneStatus;


@protocol WXKProgressing;


@interface WXKPhone : NSObject
{
@private
	int                       _fileDescriptor;
	struct termios            _originalTTYAttrs;
	WXKWhoneStatus            _status;
	
	NSObject <WXKProgressing> *_progress;
}

+ (BOOL)existsDriver;
+ (NSString *)requiredDriverName;
+ (BOOL)getParsedDataFields:(NSData **)dataFields fieldNumber:(unsigned)fieldNum fromData:(NSData *)rawData;

- (BOOL)openConnectionWithPassword:(NSString *)password progress:(NSObject <WXKProgressing> *)progress error:(NSError **)errorPtr;
- (void)closeConnection;
- (NSArray *)arrayOfDataType:(WXKPhoneDataType)dataType error:(NSError **)errorPtr;
- (BOOL)setArray:(NSArray *)dataArray ofDataType:(WXKPhoneDataType)dataType error:(NSError **)errorPtr;
- (NSArray *)listOfDataType:(WXKPhoneDataType)dataType error:(NSError **)errorPtr;
- (NSArray *)dataArrayFromFiles:(NSArray *)files error:(NSError **)errorPtr;

@end
